<?php

use \Elementor\Group_Control_Image_Size;

class Product_Amazon_Cat_Box extends \Elementor\Widget_Base {

	public function get_name() {
		return 'product-amazon-cat-box';
	}

	public function get_title() {
		return __( 'product catgory', 'negarin' );
	}

	
	public function get_icon() {
		return 'eicon-products';
	}

	public function get_categories() {
		return [ 'elementor-widget-be-shop' ];
	}

	      protected function register_controls()
    {
        $this->init_content_general_controls();
    }

    protected function init_content_general_controls() {

		$this->start_controls_section(
			'differ_content',
			[
				'label' => __( 'Grid', 'negarin' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'grid_style',
			[
			  'label' => __( 'Grid Style', 'negarin' ),
			  'type' => \Elementor\Controls_Manager::SELECT,
			  'default' => '1',
			  'options' => [
			  '1' => esc_html__( 'Layout 1', 'negarin' ),
			  ],
			]
			);
     $this->end_controls_section();
        $this->start_controls_section(
            'content_section_cat',
            [
              'label' => __( 'slider catgory', 'negarin' ),
              'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
          );
          $repeater = new \Elementor\Repeater();
          $repeater->add_control(
              'list_title_cat', [
                  'label' => __( 'Title', 'negarin' ),
                  'type' => \Elementor\Controls_Manager::TEXT,
                  'default' => __( 'List Title' , 'negarin' ),
                  'label_block' => true,
              ]
          );
          $repeater->add_control(
            'list_title_cat_two', [
                'label' => __( 'Title more', 'negarin' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( 'see more' , 'negarin' ),
                'label_block' => true,
            ]
        );
          $repeater->add_control(
            'website_link_cat',
            [
              'label' => __( 'Link', 'negarin' ),
              'type' => \Elementor\Controls_Manager::URL,
              'placeholder' => __( 'https://your-link.com', 'negarin' ),
              'show_external' => true,
              'default' => [
                'url' => '',
                'is_external' => true,
                'nofollow' => true,
              ],
            ]
          );
          $repeater->add_control(
            'my_plugin_product_grid_product_filter',
            [
                'label' => esc_html__( 'Filter By', 'negarin' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'recent',
                'options' => [
                    'recent' => esc_html__( 'Recent Products', 'negarin' ),
                    'featured' => esc_html__( 'Featured Products', 'negarin' ),
                    'best_selling' => esc_html__( 'Best Selling Products', 'negarin' ),
                    'sale' => esc_html__( 'Sale Products', 'negarin' ),
                    'top_rated' => esc_html__( 'Top Rated Products', 'negarin' ),
                    'mixed_order' => esc_html__( 'Mixed order Products', 'negarin' ),
                ],
            ]
        );
        $repeater->add_control(
          'my_plugin_product_grid_products_count',
          [
             'label'   => __( 'Products Count', 'negarin' ),
             'type'    => \Elementor\Controls_Manager::SELECT,
             'default' => '1',
             'options' => [
                '1' => esc_html__( 'Layout 1', 'negarin' ),
                '2' => esc_html__( 'Layout 2', 'negarin' ),
                '3' => esc_html__( 'Layout 3', 'negarin' ),
                '4' => esc_html__( 'Layout 4', 'negarin' ),
                ],
          ]
        );

        $repeater->add_control(
            'my_plugin_product_grid_categories',
            [
                'label' => esc_html__( 'Product Categories', 'negarin' ),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'label_block' => true,
                'multiple' => true,
                'options' => my_plugin_taxonomy_list(),
            ]
        );

        $repeater->add_control(
            'custom_order',
            [
                'label' => esc_html__( 'Custom order', 'negarin' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $repeater->add_control(
            'orderby',
            [
                'label' => esc_html__( 'Orderby', 'negarin' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'none',
                'options' => [
                    'none'          => esc_html__('None','negarin'),
                    'ID'            => esc_html__('ID','negarin'),
                    'date'          => esc_html__('Date','negarin'),
                    'name'          => esc_html__('Name','negarin'),
                    'title'         => esc_html__('Title','negarin'),
                    'comment_count' => esc_html__('Comment count','negarin'),
                    'rand'          => esc_html__('Random','negarin'),
                ],
                'condition' => [
                    'custom_order' => 'yes',
                ]
            ]
        );

        $repeater->add_control(
            'order',
            [
                'label' => esc_html__( 'order', 'negarin' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'DESC',
                'options' => [
                    'DESC'  => esc_html__('Descending','negarin'),
                    'ASC'   => esc_html__('Ascending','negarin'),
                ],
                'condition' => [
                    'custom_order' => 'yes',
                ]
            ]
        );
        $this->add_control(
            'list_cat',
            [
              'label' => __( 'Repeater List', 'negarin' ),
              'type' => \Elementor\Controls_Manager::REPEATER,
              'fields' => $repeater->get_controls(),
              'default' => [
                [
                  'list_title' => __( 'Title #1', 'negarin' ),
                  'list_content' => __( 'Item content. Click the edit button to change this text.', 'negarin' ),
                ],
                [
                  'list_title' => __( 'Title #2', 'negarin' ),
                  'list_content' => __( 'Item content. Click the edit button to change this text.', 'negarin' ),
                ],
                [
                    'list_title' => __( 'Title #3', 'negarin' ),
                    'list_content' => __( 'Item content. Click the edit button to change this text.', 'negarin' ),
                ],
                [
                    'list_title' => __( 'Title #4', 'negarin' ),
                    'list_content' => __( 'Item content. Click the edit button to change this text.', 'negarin' ),
                ],
                
              ],
              'title_field' => '{{{ list_title }}}',
            ]
          );
  
          $this->end_controls_section();
          $this->start_controls_section(
            'section_style',
            [
              'label' => __( 'Style self', 'negarin' ),
              'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
          );
          $this->add_control(
            'background_color',
            [
              'label' => __( 'background color', 'negarin' ),
              'type' => \Elementor\Controls_Manager::COLOR,
              'default' => '#fff;',
              'scheme' => [
                'type' => \Elementor\Core\Schemes\Color::get_type(),
                'value' => \Elementor\Core\Schemes\Color::COLOR_1,
              ],
              'selectors' => [
                '{{WRAPPER}} .title' => 'color: {{VALUE}}',
              ],
            ]
          );
          $this->add_control(
            'description_color',
            [ 
              'label' => __( 'color title post', 'negarin' ),
              'type' => \Elementor\Controls_Manager::COLOR,
              'default' => '#212121;',
              'scheme' => [
                'type' => \Elementor\Core\Schemes\Color::get_type(),
                'value' => \Elementor\Core\Schemes\Color::COLOR_1,
              ],
              'selectors' => [
                '{{WRAPPER}} .title' => 'color: {{VALUE}}',
              ],
            ]
          );
          $this->add_control(
            'background_color_code_self',
            [
              'label' => __( 'color see more', 'negarin' ),
              'type' => \Elementor\Controls_Manager::COLOR,
              'default' => '#212121',
              'scheme' => [
                'type' => \Elementor\Core\Schemes\Color::get_type(),
                'value' => \Elementor\Core\Schemes\Color::COLOR_1,
              ],
              'selectors' => [
                '{{WRAPPER}} .title' => 'color: {{VALUE}}',
              ],
            ]
          );


          $this->end_controls_section();
       
	}


	protected function render() { 
        $settings = $this->get_settings_for_display();
        $grid_style = $settings['grid_style']; ?>
        <section style="background-color: unset;" class="margin-top-50 flex landing-hero"<?php echo $this->get_render_attribute_string( 'background_image' ); ?>>
        <div class="amazon-cat-slidE">
    <div class="col-12">
	   <div class="container">
			<div class="row">
            <?php if ( $settings['list_cat'] ) { 
                foreach (  $settings['list_cat'] as $item ) { 
                ?>
                <div class="col-12 col-sm-6 col-md-4 col-lg-3 margin_a10">
                    <div class="amazon_cat_cart">
                        <article class="amazon_box">
                            <header>
                                <h2 style="color:<?php echo $settings['description_color']; ?>"><?php echo $item['list_title_cat']; ?></h2>
                            </header>
                            <div class="cardui-body">
                                    <div>
                                    <?php
                              $product_type       = $item['my_plugin_product_grid_product_filter'];
                              $per_page           = $item['my_plugin_product_grid_products_count'];
                              $custom_order_ck    = $item['custom_order'];
                              $orderby            = $item['orderby'];
                              $order              = $item['order'];
                              $producttab          = $this->get_settings_for_display('producttab');
                      // WooCommerce Category
                      $args = array(
                          'post_type'             => 'product',
                          'post_status'           => 'publish',
                          'ignore_sticky_posts'   => 1,
                          'posts_per_page'        => $per_page,
                      );
                      switch( $product_type ){

                          case 'sale':
                              $args['post__in'] = array_merge( array( 0 ), wc_get_product_ids_on_sale() );
                          break;

                          case 'featured':
                              $args['tax_query'][] = array(
                                  'taxonomy' => 'product_visibility',
                                  'field'    => 'name',
                                  'terms'    => 'featured',
                                  'operator' => 'IN',
                              );
                          break;

                          case 'best_selling':
                              $args['meta_key']   = 'total_sales';
                              $args['orderby']    = 'meta_value_num';
                              $args['order']      = 'desc';
                          break;

                          case 'top_rated':
                              $args['meta_key']   = '_wc_average_rating';
                              $args['orderby']    = 'meta_value_num';
                              $args['order']      = 'desc';
                          break;

                          case 'mixed_order':
                              $args['orderby']    = 'rand';
                          break;

                          default: /* Recent */
                              $args['orderby']    = 'date';
                              $args['order']      = 'desc';
                          break;
                      }

                      // Custom Order
                      if( $custom_order_ck == 'yes' ){
                          $args['orderby'] = $orderby;
                          $args['order'] = $order;
                      }

                      $get_product_categories = $item['my_plugin_product_grid_categories']; // get custom field value
                      $product_cats = str_replace(' ', '', $get_product_categories);

                      if ( "0" != $get_product_categories) {
                          if( is_array($product_cats) && count($product_cats) > 0 ){
                              $field_name = is_numeric($product_cats[0])?'term_id':'slug';
                              $args['tax_query'][] = array(
                                  array(
                                      'taxonomy' => 'product_cat',
                                      'terms' => $product_cats,
                                      'field' => $field_name,
                                      'include_children' => false
                                  )
                              );
                          }
                      }

                      $products = new \WP_Query( $args );
                      if ( $producttab == 'yes' ) { 
                              $m=0;
                              if( is_array( $product_cats ) && count( $product_cats ) > 0 ){

                                  // Category retrive
                                  $catargs = array(
                                      'orderby'    => 'name',
                                      'order'      => 'ASC',
                                      'hide_empty' => true,
                                      'slug'       => $product_cats,
                                  );
                                  $prod_categories = get_terms( 'product_cat', $catargs);

                                  foreach( $prod_categories as $prod_cats ){
                                      $m++;
                                      $field_name = is_numeric( $product_cats[0] ) ? 'term_id' : 'slug';
                                      $args['tax_query'] = array(
                                          array(
                                              'taxonomy' => 'product_cat',
                                              'terms' => $prod_cats,
                                              'field' => $field_name,
                                              'include_children' => false
                                          ),
                                      );
                                      if( 'featured' == $product_type ){
                                          $args['tax_query'][] = array(
                                              'taxonomy' => 'product_visibility',
                                              'field'    => 'name',
                                              'terms'    => 'featured',
                                              'operator' => 'IN',
                                          );
                                      }
                                  }
                              }
                          };
                      if( is_array( $product_cats ) && (count( $product_cats ) > 0) && ( $producttab == 'yes' ) ):
                              $j=0;
                              foreach( $product_cats as $cats ):
                                  $j++;
                                  $field_name = is_numeric($product_cats[0])?'term_id':'slug';
                                  $args['tax_query'] = array(
                                      array(
                                          'taxonomy' => 'product_cat',
                                          'terms' => $cats,
                                          'field' => $field_name,
                                          'include_children' => false
                                      )
                                  );
                                  if( 'featured' == $product_type ){
                                      $args['tax_query'][] = array(
                                          'taxonomy' => 'product_visibility',
                                          'field'    => 'name',
                                          'terms'    => 'featured',
                                          'operator' => 'IN',
                                      );
                                  }
                                  $products = new \WP_Query( $args );

                                  if( $products->have_posts() ):
                                  ?>
                              <?php endif; endforeach;?>
                          <?php else:?>
                          <?php 			
                          $k=1;
                          if( $products->have_posts() ):
                              while( $products->have_posts() ): $products->the_post(); ?>
                                  <a class="<?php
                                  if( 2 == $per_page ):
                                          echo 'per_page_2';
                                      elseif( 3 == $per_page ):
                                          echo 'per_page_3';
                                      elseif( 4 == $per_page ):
                                          echo 'per_page_4';
                                  endif;
                                  ?>" href="<?php echo get_permalink() ?>"><?php the_post_thumbnail( 'medium_large' ); ?></a>
                                  <?php
                                $k++; endwhile; wp_reset_postdata();
                                wp_reset_postdata();
                              endif;
                        endif;
                                ?>                                   
                            </div>
                            </div>
                            <footer>
                                <a style="color:<?php echo $settings['background_color_code_self']; ?>" href="<?php echo $item['website_link_cat']['url']; ?>"><?php echo $item['list_title_cat_two']; ?></a>
                            </footer>
                        </article>
                    </div>
                </div>

                <?php
                }
             } ?>

			</div>
    </div>
    </div>
        </div>
        </section>
		<?php
        
	}

}