<?php
/**
 * list item
 *
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class list_Item_Mega extends \Elementor\Widget_Base {

	public function get_name() {
		return 'list-item-mega';
	}

	public function get_title() {
		return __( 'list item', 'negarin' );
	}

	public function get_icon() {
		return 'eicon-editor-list-ul';
	}

	public function get_categories() {
		return [ 'elementor-widget-be' ];
	}

	      protected function register_controls()
    {
        $this->init_content_general_controls();
    }

    protected function init_content_general_controls() {
		$this->start_controls_section(
			'content_section_1',
			[
			  'label' => __( 'General', 'negarin' ),
			  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
          );
          $this->add_control(
			'list_title', [
				'label' => __( 'Title', 'negarin' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'List Title' , 'negarin' ),
				'label_block' => true,
			]
        );
		  $this->add_control(
			'title_link',
			[
			  'label' => __( 'Link', 'negarin' ),
			  'type' => \Elementor\Controls_Manager::URL,
			  'placeholder' => __( 'https://your-link.com', 'negarin' ),
			  'show_external' => true,
			  'default' => [
				'url' => '',
				'is_external' => true,
				'nofollow' => true,
			  ],
			]
		  );
		  $this->add_control(
			'icon',
			[
				'label' => __( 'Icon', 'negarin' ),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'fas fa-star',
					'library' => 'solid',
				],
			]
		);
		$this->add_control(
			'icon_align_gr',
			[
				'label' => __( 'Alignment', 'negarin' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => __( 'Left', 'negarin' ),
						'icon' => 'fa fa-align-left',
					],
					'center' => [
						'title' => __( 'Center', 'negarin' ),
						'icon' => 'fa fa-align-center',
					],
					'right' => [
						'title' => __( 'Right', 'negarin' ),
						'icon' => 'fa fa-align-right',
					],
				],
				'default' => 'center',
				'toggle' => true,
			]
		);
		  $this->end_controls_section();
		  $this->start_controls_section(
			'content_section',
			[
			  'label' => __( 'Content', 'negarin' ),
			  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
          );
		  $repeater = new \Elementor\Repeater();
		  $repeater->add_control(
			'list_title', [
				'label' => __( 'Title', 'negarin' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'List Title' , 'negarin' ),
				'label_block' => true,
			]
		);
		  $repeater->add_control(
			'website_link',
			[
			  'label' => __( 'Link', 'negarin' ),
			  'type' => \Elementor\Controls_Manager::URL,
			  'placeholder' => __( 'https://your-link.com', 'negarin' ),
			  'show_external' => true,
			  'default' => [
				'url' => '',
				'is_external' => true,
				'nofollow' => true,
			  ],
			]
		  );
		  
		$repeater->add_control(
			'icon_list',
			[
				'label' => __( 'Icon', 'negarin' ),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'fas fa-star',
					'library' => 'solid',
				],
			]
		);
		$repeater->add_control(
			'icon_align',
			[
				'label' => __( 'Alignment', 'negarin' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => __( 'Left', 'negarin' ),
						'icon' => 'fa fa-align-left',
					],
					'center' => [
						'title' => __( 'Center', 'negarin' ),
						'icon' => 'fa fa-align-center',
					],
					'right' => [
						'title' => __( 'Right', 'negarin' ),
						'icon' => 'fa fa-align-right',
					],
				],
				'default' => 'left',
				'toggle' => true,
			]
		);
		  $this->add_control(
			'list',
			[
			  'label' => __( 'Repeater List', 'negarin' ),
			  'type' => \Elementor\Controls_Manager::REPEATER,
			  'fields' => $repeater->get_controls(),
			  'default' => [
				[
				  'list_title' => __( 'Title #1', 'negarin' ),
				  'list_content' => __( 'Item content. Click the edit button to change this text.', 'negarin' ),
				],
				[
				  'list_title' => __( 'Title #2', 'negarin' ),
				  'list_content' => __( 'Item content. Click the edit button to change this text.', 'negarin' ),
				],
			  ],
			  'title_field' => '{{{ list_title }}}',
			]
		  );
		$this->end_controls_section();
	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		?>
        <div class="container">
			<ul class="list-item-mega">
				<span class="title-list-head"><a href="<?php echo $settings['title_link']['url']; ?>"><?php echo $settings['list_title']; ?> <span class="icon_setti" style="float:<?php echo $settings['icon_align_gr'] ; ?>"><?php \Elementor\Icons_Manager::render_icon( $settings['icon'], [ 'aria-hidden' => 'true' ] ); ?></span></a></span>
			<?php 
			if ( $settings['list'] ) {
			foreach (  $settings['list'] as $item ) { ?>
                <li>
					<a href="<?php echo $item['website_link']['url']; ?>"><?php echo $item['list_title']; ?>
					<span class="icon_setti" style="float:<?php echo $item['icon_align'] ; ?>"><?php \Elementor\Icons_Manager::render_icon( $item['icon_list'], [ 'aria-hidden' => 'true' ] ); ?></span>
				</a>
				</li>
			<?php }
			} ?>
			</ul>
        </div>
		<?php
	}

}