<?php
add_action('admin_init', 'add_meta_boxes', 1);
function add_meta_boxes()
{
	add_meta_box('repeatable-fields2', __('Specifications', 'negarin'), 'repeatable_meta_box_display2', 'product', 'normal', 'high');
	add_meta_box('repeatable-fields', __('link', 'negarin'), 'repeatable_meta_box_display', 'product', 'normal', 'high');
	add_meta_box('repeatable-fields3', __('affiliate marketing', 'negarin'), 'repeatable_meta_box_display3', 'product', 'normal', 'high');
}

function repeatable_meta_box_display2()
{
	global $post;
	$repeatable_fields2 = get_post_meta($post->ID, 'repeatable_fields2', true);
	wp_nonce_field('repeatable_meta_box_nonce2', 'repeatable_meta_box_nonce2');
?>
	<script type="text/javascript">
		jQuery(document).ready(function($) {
			$('.metabox_submit').click(function(e) {
				e.preventDefault();
				$('#publish').click();
			});
			$('#add-row2').on('click', function() {
				var row = $('.empty-row1.screen-reader-text').clone(true);
				row.removeClass('empty-row1 screen-reader-text');
				row.insertBefore('#repeatable-fieldset-one1 tbody>tr:last');
				return false;
			});
			$('.remove-row1').on('click', function() {
				$(this).parents('tr').remove();
				return false;
			});

			$('#repeatable-fieldset-one1 tbody').sortable({
				opacity: 0.6,
				revert: true,
				cursor: 'move',
				handle: '.sort'
			});
			$('#add-row3').on('click', function() {
				var row = $('.empty-row3.screen-reader-text').clone(true);
				row.removeClass('empty-row3 screen-reader-text');
				row.insertBefore('#repeatable-fieldset-one3 tbody>tr:last');
				return false;
			});
			$('.remove-row3').on('click', function() {
				$(this).parents('tr').remove();
				return false;
			});

			$('#repeatable-fieldset-one3 tbody').sortable({
				opacity: 0.6,
				revert: true,
				cursor: 'move',
				handle: '.sort'
			});
			$('#add-row').on('click', function() {
				var row = $('.empty-row.screen-reader-text').clone(true);
				row.removeClass('empty-row screen-reader-text');
				row.insertBefore('#repeatable-fieldset-one tbody>tr:last');
				return false;
			});
			$('.remove-row').on('click', function() {
				$(this).parents('tr').remove();
				return false;
			});

			$('#repeatable-fieldset-one tbody').sortable({
				opacity: 0.6,
				revert: true,
				cursor: 'move',
				handle: '.sort'
			});
		});
	</script>
	<table id="repeatable-fieldset-one1" width="100%">
		<thead>
			<tr>
				<th width="2%"></th>
				<th width="30%"><?php _e('Name', 'negarin'); ?></th>
				<th width="60%"><?php _e('description', 'negarin'); ?></th>
				<th width="2%"></th>
			</tr>
		</thead>
		<tbody>
			<?php

			if ($repeatable_fields2) :

				foreach ($repeatable_fields2 as $field) {
			?>
					<tr>
						<td><a class="button remove-row1" href="#">-</a></td>
						<td><input type="text" class="widefat" name="name2[]" value="<?php if ($field['name2'] != '') echo esc_attr($field['name2']); ?>" /></td>

						<td><input type="text" class="widefat" name="url2[]" value="<?php if ($field['url2'] != '') echo esc_attr($field['url2']); ?>" /></td>
						<td><a class="sort">|||</a></td>

					</tr>
				<?php
				}
			else :
				// show a blank one
				?>
				<tr>
					<td><a class="button remove-row1" href="#">-</a></td>
					<td><input type="text" class="widefat" name="name2[]" /></td>
					<td><input type="text" class="widefat" name="url2[]" value="Text" /></td>
					<td><a class="sort">|||</a></td>

				</tr>
			<?php endif; ?>

			<!-- empty hidden one for jQuery -->
			<tr class="empty-row1 screen-reader-text">
				<td><a class="button remove-row1" href="#">-</a></td>
				<td><input type="text" class="widefat" name="name2[]" /></td>

				<td><input type="text" class="widefat" name="url2[]" value="Text" /></td>
				<td><a class="sort">|||</a></td>

			</tr>
		</tbody>
	</table>

	<p><a id="add-row2" class="button" href="#"><?php _e('Add another', 'negarin'); ?></a>
		<input type="submit" class="metabox_submit" value="<?php _e('Save', 'negarin'); ?>" />
	</p>

<?php
}

// -------------------------------------------------------------------------- 2 
function repeatable_meta_box_display3()
{
	global $post;
	$repeatable_fields3 = get_post_meta($post->ID, 'repeatable_fields3', true);
	wp_nonce_field('repeatable_meta_box_nonce3', 'repeatable_meta_box_nonce3');
?>
	<table id="repeatable-fieldset-one3" width="100%">
		<thead>
			<tr>
				<th width="2%"></th>
				<th width="30%"><?php _e('Name', 'negarin'); ?></th>
				<th width="60%"><?php _e('URL', 'negarin'); ?></th>
				<th width="2%"></th>
			</tr>
		</thead>
		<tbody>
			<?php

			if ($repeatable_fields3) :

				foreach ($repeatable_fields3 as $field) {
			?>
					<tr>
						<td><a class="button remove-row3" href="#">-</a></td>
						<td><input type="text" class="widefat" name="name3[]" value="<?php if ($field['name3'] != '') echo esc_attr($field['name3']); ?>" /></td>
						<td><input type="text" class="widefat" name="url3[]" value="<?php if ($field['url3'] != '') echo esc_attr($field['url3']);
																					else echo 'http://'; ?>" /></td>
						<td><a class="sort">|||</a></td>

					</tr>
				<?php
				}
			else :
				// show a blank one
				?>
				<tr>
					<td><a class="button remove-row3" href="#">-</a></td>
					<td><input type="text" class="widefat" name="name3[]" /></td>

					<td><input type="text" class="widefat" name="url3[]" value="http://" /></td>
					<td><a class="sort">|||</a></td>

				</tr>
			<?php endif; ?>

			<!-- empty hidden one for jQuery -->
			<tr class="empty-row3 screen-reader-text">
				<td><a class="button remove-row3" href="#">-</a></td>
				<td><input type="text" class="widefat" name="name3[]" /></td>

				<td><input type="text" class="widefat" name="url3[]" value="http://" /></td>
				<td><a class="sort">|||</a></td>

			</tr>
		</tbody>
	</table>

	<p><a id="add-row3" class="button" href="#"><?php _e('Add another', 'negarin'); ?></a>
		<input type="submit" class="metabox_submit" value="Save" />
	</p>

<?php
}
// -------------------------------------------------------------------------- 3
function repeatable_meta_box_display()
{
	global $post;
	$repeatable_fields = get_post_meta($post->ID, 'repeatable_fields', true);
	wp_nonce_field('repeatable_meta_box_nonce', 'repeatable_meta_box_nonce');
?>

	<table id="repeatable-fieldset-one" width="100%">
		<thead>
			<tr>
				<th width="2%"></th>
				<th width="30%"><?php _e('Name', 'negarin'); ?></th>
				<th width="60%"><?php _e('URL', 'negarin'); ?></th>
				<th width="2%"></th>
			</tr>
		</thead>
		<tbody>
			<?php

			if ($repeatable_fields) :

				foreach ($repeatable_fields as $field) {
			?>
					<tr>
						<td><a class="button remove-row" href="#">-</a></td>
						<td><input type="text" class="widefat" name="name[]" value="<?php if ($field['name'] != '') echo esc_attr($field['name']); ?>" /></td>

						<td><input type="text" class="widefat" name="url[]" value="<?php if ($field['url'] != '') echo esc_attr($field['url']);
																					else echo 'http://'; ?>" /></td>
						<td><a class="sort">|||</a></td>

					</tr>
				<?php
				}
			else :
				// show a blank one
				?>
				<tr>
					<td><a class="button remove-row" href="#">-</a></td>
					<td><input type="text" class="widefat" name="name[]" /></td>

					<td><input type="text" class="widefat" name="url[]" value="http://" /></td>
					<td><a class="sort">|||</a></td>

				</tr>
			<?php endif; ?>
			<!-- empty hidden one for jQuery -->
			<tr class="empty-row screen-reader-text">
				<td><a class="button remove-row" href="#">-</a></td>
				<td><input type="text" class="widefat" name="name[]" /></td>

				<td><input type="text" class="widefat" name="url[]" value="http://" /></td>
				<td><a class="sort">|||</a></td>

			</tr>
		</tbody>
	</table>
	<p><a id="add-row" class="button" href="#"><?php _e('Add another', 'negarin'); ?></a>
		<input type="submit" class="metabox_submit" value="Save" />
	</p>
<?php
}

add_action('save_post', 'repeatable_meta_box_save');
function repeatable_meta_box_save($post_id)
{
	if (
		!isset($_POST['repeatable_meta_box_nonce']) ||
		!wp_verify_nonce($_POST['repeatable_meta_box_nonce'], 'repeatable_meta_box_nonce')
	)
		return;

	if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE)
		return;

	if (!current_user_can('edit_post', $post_id))
		return;

	$old = get_post_meta($post_id, 'repeatable_fields', true);
	$new = array();

	$names = $_POST['name'];
	$urls = $_POST['url'];

	$count = count($names);

	for ($i = 0; $i < $count; $i++) {
		if ($names[$i] != '') :
			$new[$i]['name'] = stripslashes(strip_tags($names[$i]));


			if ($urls[$i] == 'http://')
				$new[$i]['url'] = '';
			else
				$new[$i]['url'] = stripslashes($urls[$i]); // and however you want to sanitize
		endif;
	}

	if (!empty($new) && $new != $old)
		update_post_meta($post_id, 'repeatable_fields', $new);
	elseif (empty($new) && $old)
		delete_post_meta($post_id, 'repeatable_fields', $old);

	$old2 = get_post_meta($post_id, 'repeatable_fields2', true);
	$new2 = array();

	$names2 = $_POST['name2'];
	$urls2 = $_POST['url2'];

	$count2 = count($names2);

	for ($c = 0; $c < $count2; $c++) {
		if ($names2[$c] != '') :
			$new2[$c]['name2'] = stripslashes(strip_tags($names2[$c]));


			if ($urls2[$c] == 'http://')
				$new2[$c]['url2'] = '';
			else
				$new2[$c]['url2'] = stripslashes($urls2[$c]); // and however you want to sanitize
		endif;
	}

	if (!empty($new2) && $new2 != $old2)
		update_post_meta($post_id, 'repeatable_fields2', $new2);
	elseif (empty($new2) && $old2)
		delete_post_meta($post_id, 'repeatable_fields2', $old2);

	$old3 = get_post_meta($post_id, 'repeatable_fields3', true);
	$new3 = array();

	$names3 = $_POST['name3'];
	$urls3 = $_POST['url3'];

	$count3 = count($names3);

	for ($j = 0; $j < $count3; $j++) {
		if ($names3[$j] != '') :
			$new3[$j]['name3'] = stripslashes(strip_tags($names3[$j]));

			if ($urls3[$j] == 'http://')
				$new3[$j]['url3'] = '';
			else
				$new3[$j]['url3'] = stripslashes($urls3[$j]); // and however you want to sanitize
		endif;
	}

	if (!empty($new3) && $new3 != $old3)
		update_post_meta($post_id, 'repeatable_fields3', $new3);
	elseif (empty($new3) && $old3)
		delete_post_meta($post_id, 'repeatable_fields3', $old3);
}
